# 计时
如果非常想要优化你的方法，你需要了解这款游戏中时间的计量方式，也就是这个解锁项的内容。

## 新函数
若要衡量事情花费的时间，有两个函数可用：

`get_time()` 返回自游戏开始以来的秒数。

`get_tick_count()` 返回自执行开始以来经过的 tick 数。

这两个函数以及 `quick_print()` 是完全免费的，甚至连调用它们的操作也是免费的。

## 运行时详情

### 注意
这与现实世界中的执行方式不一样，只是为这款游戏制定的规则，以便创造一个一致且易于理解的计时模型。
你可能只有在想要极致优化代码时才会关心这个。


代码执行的基本时间单位被称为“tick”。在没有速度升级和能量的情况下，执行速度为每秒 `400` ticks。

通常，组合两个值的操作（例如 `+, -, *, /, //, %, and, or, ...`）需要一个 tick 来运行。
单值 `-` 和 `not` 是免费的。
一个 `if` 分支也需要一个 tick 来运行（不包括计算条件表达式所需的时间）。
函数调用以及变量的读取和写入是免费的，但函数定义需要 1 个 tick。
`import` 语句是免费的。
使用 `.` 运算符访问导入的模块是免费的。
如果一个函数或模块是通过参数或变量赋值传递的，则使用时将花费 1 个 tick 而不是 0。
`for` 和 `while` 循环开始时需要一个 tick，但迭代本身是免费的（未计入给条件/序列表达式求值的时间）。
`return`、`break` 和 `continue` 都是免费的。
`pass` 需要一个 tick，所以它可以用来创造精确的延迟。
使用索引运算符对数据结构进行索引需要一个 tick，而在涉及字典或集合的情况下，还需要根据键的大小花费额外的 tick。

执行内置函数所需的 tick 数在每个函数的文档中都有单独说明。